/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.spawner;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class AnimalRespawnWorldData
extends WorldSavedData {
    private static final String NAME = "tfc_respawn";
    private static final int REGION_SIZE = 16;
    private final Map<ResourceLocation, Map<ChunkPos, Long>> respawnMap = new HashMap<ResourceLocation, Map<ChunkPos, Long>>();

    @Nonnull
    public static AnimalRespawnWorldData get(@Nonnull World world) {
        MapStorage mapStorage = world.func_175693_T();
        if (mapStorage != null) {
            AnimalRespawnWorldData data = (AnimalRespawnWorldData)mapStorage.func_75742_a(AnimalRespawnWorldData.class, NAME);
            if (data == null) {
                data = new AnimalRespawnWorldData(NAME);
                data.func_76185_a();
                mapStorage.func_75745_a(NAME, (WorldSavedData)data);
            }
            return data;
        }
        throw new IllegalStateException("Unable to access animal respawning data!");
    }

    public AnimalRespawnWorldData(String name) {
        super(name);
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        NBTTagList tag = nbt.func_150295_c("animal", 10);
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTTagCompound animalNbt = tag.func_150305_b(i);
            ResourceLocation name = new ResourceLocation(animalNbt.func_74779_i("name"));
            NBTTagList gridValues = nbt.func_150295_c("values", 10);
            HashMap<ChunkPos, Long> internal = new HashMap<ChunkPos, Long>();
            for (int j = 0; j < gridValues.func_74745_c(); ++j) {
                NBTTagCompound gridTag = gridValues.func_150305_b(i);
                ChunkPos pos = new ChunkPos(gridTag.func_74762_e("x"), gridTag.func_74762_e("z"));
                long respawn = gridTag.func_74763_f("respawn");
                internal.put(pos, respawn);
            }
            this.respawnMap.put(name, internal);
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbt) {
        NBTTagList tag = new NBTTagList();
        for (ResourceLocation animal : this.respawnMap.keySet()) {
            NBTTagCompound animalNbt = new NBTTagCompound();
            animalNbt.func_74778_a("name", animal.toString());
            NBTTagList gridValues = new NBTTagList();
            Map<ChunkPos, Long> internal = this.respawnMap.get(animal);
            for (ChunkPos gridPos : internal.keySet()) {
                NBTTagCompound gridTag = new NBTTagCompound();
                gridTag.func_74768_a("x", gridPos.field_77276_a);
                gridTag.func_74768_a("z", gridPos.field_77275_b);
                gridTag.func_74772_a("respawn", internal.get(gridPos).longValue());
                gridValues.func_74742_a((NBTBase)gridTag);
            }
            animalNbt.func_74782_a("values", (NBTBase)gridValues);
            tag.func_74742_a((NBTBase)animalNbt);
        }
        nbt.func_74782_a("animal", (NBTBase)tag);
        return nbt;
    }

    public long getLastRespawnTick(Entity entity, ChunkPos chunkPos) {
        ResourceLocation entityKey = EntityList.func_191301_a((Entity)entity);
        Map<ChunkPos, Long> internal = this.respawnMap.get(entityKey);
        if (internal == null) {
            return 0L;
        }
        ChunkPos grid = new ChunkPos(chunkPos.field_77276_a - chunkPos.field_77276_a % 16, chunkPos.field_77275_b - chunkPos.field_77275_b % 16);
        return internal.getOrDefault(grid, 0L);
    }

    public void setLastRespawnTick(Entity entity, ChunkPos chunkPos, long tick) {
        ResourceLocation entityKey = EntityList.func_191301_a((Entity)entity);
        ChunkPos grid = new ChunkPos(chunkPos.field_77276_a - chunkPos.field_77276_a % 16, chunkPos.field_77275_b - chunkPos.field_77275_b % 16);
        this.respawnMap.computeIfAbsent(entityKey, k -> new HashMap()).put(grid, tick);
        this.func_76185_a();
    }
}

